/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.PsSlipDto;

public class PsSlipDao extends PayrollDao {
	
	/**
	 *  e[uB<br>
	 */
	public static final String TABLE = "PS_SLIP";
	
	/**
	 *  L[1B<br>
	 */
	public static final String KEY_01 = "SLIP_CODE";
	
	/**
	 *  L[2B<br>
	 */
	public static final String KEY_02 = "DETAIL_TYPE";
	
	/**
	 *  L[3B<br>
	 */
	public static final String KEY_03 = "DETAIL_CODE";
		
	public static final String COL_SLIP_CODE   = "SLIP_CODE"  ;
	public static final String COL_DETAIL_TYPE = "DETAIL_TYPE";
	public static final String COL_DETAIL_CODE = "DETAIL_CODE";
	public static final String COL_VIEW_INDEX  = "VIEW_INDEX" ;
	
	private static final String DELETE_FLAG_COL = "DELETE_FLAG";
	
	/**
	 * {@link PayrollDao#PayrollDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * sB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public PsSlipDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		super(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * ʂDTOƂĎ擾B<br>
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	private PsSlipDto mapping() throws SQLException {
		PsSlipDto dto = new PsSlipDto();
		dto.setSlipCode  (rs.getString(COL_SLIP_CODE  ));
		dto.setDetailType(rs.getString(COL_DETAIL_TYPE));
		dto.setDetailCode(rs.getString(COL_DETAIL_CODE));
		dto.setViewIndex (rs.getByte  (COL_VIEW_INDEX ));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ʂDTOListƂĎ擾B<br>
	 * @return ʃXg
	 * @throws SQLException
	 */
	private List<PsSlipDto> mappingAll() throws SQLException {
		List<PsSlipDto> all = new ArrayList<PsSlipDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PsSlipDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}B<br>
	 * @param dto     }ΏDTO
	 * @param needLog OvۃtO
	 * @return }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(
			PsSlipDto dto, boolean needLog
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate(needLog);
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XVB<br>
	 * @param dto XVΏDTO
	 * @param needLog OvۃtO
	 * @return XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(
			PsSlipDto dto, boolean needLog
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getSlipCode  ());
			setParam(index++, dto.getDetailType());
			setParam(index++, dto.getDetailCode());
			executeUpdate(needLog);
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * `[׃Xg擾pSQL擾B<br>
	 * @return `[׃Xg擾pSQL
	 */
	public static String getQueryForSlip(String table) {
		StringBuffer sb = new StringBuffer();
		sb.append("FROM " + table + ", " + TABLE + " ");
		sb.append("WHERE ");
		sb.append(table + "." + COL_DETAIL_CODE + " = ");
		sb.append(TABLE + "." + COL_DETAIL_CODE + " ");
		sb.append("AND ");
		sb.append(TABLE + "." + COL_SLIP_CODE + " = ? ");
		sb.append("AND ");
		sb.append(TABLE + "." + COL_DETAIL_TYPE + " = ? ");
		sb.append("AND ");
		sb.append(table + "." + DELETE_FLAG_COL + " = " + MospConst.DELETE_FLAG_OFF + " ");
		sb.append("ORDER BY " + TABLE + "." + COL_VIEW_INDEX + " ");
		return sb.toString();
	}
	
	/**
	 * p[^ݒ肷B<br>
	 * @param dto      XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PsSlipDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getSlipCode  ());
		setParam(index++, dto.getDetailType());
		setParam(index++, dto.getDetailCode());
		setParam(index++, dto.getViewIndex ());
		setCommonParams(isInsert);
	}
	
}
